<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment;

use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\Post\PostCommentTable;

final class PostCommentModel extends AbstractModel implements InterfacePostCommentGetter
{
    /**
     * getter interface
     */
    use TraitPostCommentGetters;

    public function getTableClassName(): string
    {
        return PostCommentTable::erlClass();
    }
    /*
    |--------------------------------------------------------------------------
    | override the delete logic
    |--------------------------------------------------------------------------
    */

    public function delete(): bool
    {
        PostCommentModelHelper::deleteDependencies($this);

        return parent::delete();
    }
}
